import UIKit
import PlaygroundSupport
//: ## Animation mit UIViewPropertyAnimator 
//: ## – Erste Schritte
//: Die Vorbereitungen kennen Sie bereits von der [ersten Seite](@previous)…
//Demo-View erstellen, Button verschieben und Live-View
let container = demoView(frame: CGRect(x: 0, y: 0,
                                       width: 400, height: 600))
let frame = container.frame
container.demoButton.center = CGPoint(x:frame.midX,
                                      y: frame.midY)
PlaygroundPage.current.liveView = container

//: Diesmal animiert der neue UIViewPropertyAnimator den Button. Er sammelt sämtliche Parameter zu einer Animation in einem Objekt, so kann man später erneut aus diese  zugreifen und sie ändern.
public class actionHandler: NSObject {
    public func animate() {
        let animator = UIViewPropertyAnimator(duration: 2.0, curve: .easeInOut) { 
            container.demoButton.center.x = frame.maxX
                - container.demoButton.frame.size.width
        }

        animator.addCompletion( { (position) in
            container.demoButton.setTitle("finished", for: .normal)
        })

        animator.startAnimation()
    }
}

//: Anschließend können Sie die Action wie gewohnt an den Button anhängen
let responder = actionHandler()
container.demoButton.addTarget(responder,
                               action: #selector(actionHandler.animate),
                               for: .touchDown)
//: [Nächste Seite](@next)







